/*
 * Decompiled with CFR 0.152.
 */
package ui;

import javax.swing.tree.DefaultMutableTreeNode;

public class FileBrowserNode
implements Comparable {
    protected String display;
    protected String path;
    protected String[] walk;
    protected String cache = null;
    protected boolean isUNC = false;

    public FileBrowserNode(String string) {
        if (string.startsWith("\\\\")) {
            string = string.substring(2);
            this.isUNC = true;
        }
        this.walk = string.split("\\\\");
        this.path = this.getPath();
        if (this.walk.length == 0) {
            this.isUNC = true;
            this.display = "[error]";
            this.path = "[error]";
        } else {
            this.display = this.walk[this.walk.length - 1];
        }
    }

    public int compareTo(Object object) {
        FileBrowserNode fileBrowserNode = (FileBrowserNode)object;
        return this.path.toLowerCase().compareTo(fileBrowserNode.path.toLowerCase());
    }

    public boolean isComputer() {
        return this.isDrive() && this.isUNC;
    }

    public boolean isDrive() {
        return this.walk.length == 1;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return new DefaultMutableTreeNode(this);
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String string) {
        this.cache = string;
    }

    public String getParent() {
        if (this.isComputer()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isUNC) {
            stringBuffer.append("\\\\");
        }
        for (int i = 0; i < this.walk.length - 1; ++i) {
            stringBuffer.append(this.walk[i]);
            stringBuffer.append("\\");
        }
        return stringBuffer.toString();
    }

    public String getPathNoTrailingSlash() {
        String string = this.getPath();
        return string.substring(0, string.length() - 1);
    }

    public String getPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isUNC) {
            stringBuffer.append("\\\\");
        }
        for (int i = 0; i < this.walk.length; ++i) {
            stringBuffer.append(this.walk[i]);
            stringBuffer.append("\\");
        }
        return stringBuffer.toString();
    }

    public String getChild(String string) {
        return this.getPath() + string;
    }

    public String getName() {
        return this.display;
    }

    public String toString() {
        return this.getName();
    }
}

