/*
 * Decompiled with CFR 0.152.
 */
package ui;

import aggressor.Prefs;
import aggressor.ui.UseSynthetica;
import dialog.DialogManager;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Navigator
extends JComponent
implements ListSelectionListener {
    protected CardLayout options = new CardLayout();
    protected JList navigator = new JList();
    protected JPanel switcher = new JPanel();
    protected boolean useAlternateValue = false;
    protected Map icons = new HashMap();

    public Navigator() {
        this.switcher.setLayout(this.options);
        this.navigator.setFixedCellWidth(125);
        this.setLayout(new BorderLayout());
        this.add((Component)DialogUtils.wrapComponent(new JScrollPane(this.navigator), 5), "West");
        this.add((Component)DialogUtils.wrapComponent(this.switcher, 5), "Center");
        this.navigator.setCellRenderer(new _A());
        this.navigator.addListSelectionListener(this);
        this.navigator.setModel(new DefaultListModel());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.options.show(this.switcher, (String)this.navigator.getSelectedValue());
    }

    public void useAlternateValue(boolean bl) {
        this.useAlternateValue = bl;
        this.navigator.validate();
        this.navigator.repaint();
    }

    public void set(String string) {
        this.navigator.setSelectedValue(string, true);
        this.options.show(this.switcher, string);
    }

    public void addPage(String string, Icon icon, String string2, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)DialogUtils.description(string2), "North");
        jPanel.add((Component)DialogUtils.top(jComponent), "Center");
        this.icons.put(string, icon);
        DefaultListModel defaultListModel = (DefaultListModel)this.navigator.getModel();
        defaultListModel.addElement(string);
        this.switcher.add((Component)jPanel, string);
    }

    public static void main(String[] stringArray) {
        new UseSynthetica().setup();
        JFrame jFrame = DialogUtils.dialog("Hello World", 640, 480);
        Navigator navigator = new Navigator();
        DialogManager dialogManager = new DialogManager(jFrame);
        dialogManager.startGroup("console");
        dialogManager.text("user", "User:", 20);
        dialogManager.text("pass", "Password:", 20);
        dialogManager.text("host", "Host:", 20);
        dialogManager.text("port", "Port:", 10);
        dialogManager.endGroup();
        navigator.addPage("Console", new ImageIcon(UseSynthetica.isUsingDarkMode() != false ? "./resources/cc/white/png/monitor_icon&16.png" : "./resources/cc/black/png/monitor_icon&16.png"), "This is your opportunity to edit console preferences", dialogManager.layout("console"));
        dialogManager.startGroup("console2");
        dialogManager.text("user", "User A:", 20);
        dialogManager.text("pass", "Password:", 20);
        dialogManager.text("host", "Host:", 20);
        dialogManager.text("port", "Port:", 10);
        dialogManager.text("port", "Port:", 10);
        dialogManager.text("port", "Port:", 10);
        dialogManager.endGroup();
        navigator.addPage("Console II", new ImageIcon(UseSynthetica.isUsingDarkMode() != false ? "./resources/cc/white/png/monitor_icon&16.png" : "./resources/cc/black/png/monitor_icon&16.png"), "This is another opportunity to edit stuff. I think you know the drill by now.", dialogManager.layout("console2"));
        jFrame.add((Component)navigator, "Center");
        jFrame.add((Component)DialogUtils.center(dialogManager.action("Close")), "South");
        jFrame.setVisible(true);
    }

    private class _A
    extends JLabel
    implements ListCellRenderer {
        private _A() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String[] stringArray = object.toString().split("!!");
            String string = Navigator.this.useAlternateValue && stringArray.length == 2 ? stringArray[1] : stringArray[0];
            boolean bl3 = false;
            if ('*' == string.charAt(0)) {
                bl3 = true;
                string = string.substring(1);
            }
            this.setText(string);
            this.setIcon((Icon)Navigator.this.icons.get(object));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (bl3) {
                this.setForeground(Prefs.getPreferences().getColor("connection.active.color", "#0000ff"));
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

