#ifndef INTERFACE_H
#define INTERFACE_H

#define CURRENT_VERSION		0x040000

#define GET_VERSION CTL_CODE(FILE_DEVICE_UNKNOWN,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define INIT_TRACER CTL_CODE(FILE_DEVICE_UNKNOWN,0x801,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define SET_RANGE CTL_CODE(FILE_DEVICE_UNKNOWN,0x802,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define STOP_TRACER CTL_CODE(FILE_DEVICE_UNKNOWN,0x803,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define STATE_WAIT		0x0
#define STATE_READY		0x1

#define STATE_BUSY		0x10

#pragma pack(push,1)

typedef struct
{
	HANDLE Pid;
	ULONG_PTR StartRange;
	ULONG_PTR Size;
} PROCESS_INFO;

typedef struct
{
	ULONG_PTR CurrentIp;
	ULONG State;
} TRACER_STRUCT;

typedef struct
{
	ULONG_PTR MyCr3;
	ULONG_PTR StartRange;
	ULONG_PTR BpSize;
} BREAKPOINT;

#pragma pack(pop)

#if defined _M_AMD64
#define PAE_PDE_BASE		0xFFFFF6FB40000000
#define PAE_PTE_BASE		0xFFFFF68000000000
#elif defined _M_IX86
#define PAE_PDE_BASE		0xC0600000
#define PAE_PTE_BASE		0xC0000000
#else
!!!
#endif

#define NON_PAE_PDE_BASE	0xC0300000
#define NON_PAE_PTE_BASE	0xC0000000

#endif //INTERFACE_H