#ifndef SVM_H
#define SVM_H

enum
{
	MSR_EFER=0xc0000080,
	MSR_VM_CR=0xc0010114,
	MSR_VM_HSAVE_PA=0xc0010117
};

enum
{
	GENERICINTERCEPT1_INTR=1 << 0,
	GENERICINTERCEPT1_NMI=1 << 1,
	GENERICINTERCEPT1_SMI=1 << 2,
	GENERICINTERCEPT1_INIT=1 << 3,
	GENERICINTERCEPT1_VINTR=1 << 4,
	GENERICINTERCEPT1_CR0_SEL_WRITE=1 << 5,
	GENERICINTERCEPT1_IDTR_READ=1 << 6,
	GENERICINTERCEPT1_GDTR_READ=1 << 7,
	GENERICINTERCEPT1_LDTR_READ=1 << 8,
	GENERICINTERCEPT1_TR_READ=1 << 9,
	GENERICINTERCEPT1_IDTR_WRITE=1 << 10,
	GENERICINTERCEPT1_GDTR_WRITE=1 << 11,
	GENERICINTERCEPT1_LDTR_WRITE=1 << 12,
	GENERICINTERCEPT1_TR_WRITE=1 << 13,
	GENERICINTERCEPT1_RDTSC=1 << 14,
	GENERICINTERCEPT1_RDPMC=1 << 15,
	GENERICINTERCEPT1_PUSHF=1 << 16,
	GENERICINTERCEPT1_POPF=1 << 17,
	GENERICINTERCEPT1_CPUID=1 << 18,
	GENERICINTERCEPT1_RSM=1 << 19,
	GENERICINTERCEPT1_IRET=1 << 20,
	GENERICINTERCEPT1_INT=1 << 21,
	GENERICINTERCEPT1_INVD=1 << 22,
	GENERICINTERCEPT1_PAUSE=1 << 23,
	GENERICINTERCEPT1_HLT=1 << 24,
	GENERICINTERCEPT1_INVLPG=1 << 25,
	GENERICINTERCEPT1_INVLPGA=1 << 26,
	GENERICINTERCEPT1_IOIO=1 << 27,
	GENERICINTERCEPT1_MSR=1 << 28,
	GENERICINTERCEPT1_TASK_SWITCH=1 << 29,
	GENERICINTERCEPT1_FERR_FREEZE=1 << 30,
	GENERICINTERCEPT1_SHUTDOWN=1 << 31
};

enum
{
	GENERICINTERCEPT2_VMRUN=1 << 0,
	GENERICINTERCEPT2_VMMCALL=1 << 1,
	GENERICINTERCEPT2_VMLOAD=1 << 2,
	GENERICINTERCEPT2_VMSAVE=1 << 3,
	GENERICINTERCEPT2_STGI=1 << 4,
	GENERICINTERCEPT2_CLGI=1 << 5,
	GENERICINTERCEPT2_SKINIT=1 << 6,
	GENERICINTERCEPT2_RDTSCP=1 << 7,
	GENERICINTERCEPT2_ICEBP=1 << 8,
	GENERICINTERCEPT2_WBINVD=1 << 9,
	GENERICINTERCEPT2_MONITOR=1 << 10,
	GENERICINTERCEPT2_MWAIT=1 << 11,
	GENERICINTERCEPT2_MWAIT_CONDITIONAL=1 << 12,
	GENERICINTERCEPT2_XSETBV=1 << 13
};

enum
{
	VMCBCLEAN_INTERCEPTS=1 << 0,
	VMCBCLEAN_IOPM=1 << 1,
	VMCBCLEAN_ASID=1 << 2,
	VMCBCLEAN_TPR=1 << 3,
	VMCBCLEAN_NP=1 << 4,
	VMCBCLEAN_CR=1 << 5,
	VMCBCLEAN_DR=1 << 6,
	VMCBCLEAN_DT=1 << 7,
	VMCBCLEAN_SEG=1 << 8,
	VMCBCLEAN_CR2=1 << 9,
	VMCBCLEAN_LBR=1 << 10,
	VMCBCLEAN_AVIC=1 << 11
};

enum
{
	VMEXIT_INT0=64,
	VMEXIT_INT1=65,
	VMEXIT_INT2=66,
	VMEXIT_INT3=67,
	VMEXIT_INT4=68,
	VMEXIT_INT5=69,
	VMEXIT_INT6=70,
	VMEXIT_INT7=71,
	VMEXIT_INT8=72,
	VMEXIT_INT9=73,
	VMEXIT_INT10=74,
	VMEXIT_INT11=75,
	VMEXIT_INT12=76,
	VMEXIT_INT13=77,
	VMEXIT_INT14=78,
	VMEXIT_INT15=79,

	VMEXIT_INTR=96,
	VMEXIT_NMI=97,
	VMEXIT_SMI=98,
	VMEXIT_INIT=99,
	VMEXIT_VINTR=100,
	VMEXIT_CR0_SEL_WRITE=101,
	VMEXIT_IDTR_READ=102,
	VMEXIT_GDTR_READ=103,
	VMEXIT_LDTR_READ=104,
	VMEXIT_TR_READ=105,
	VMEXIT_IDTR_WRITE=106,
	VMEXIT_GDTR_WRITE=107,
	VMEXIT_LDTR_WRITE=108,
	VMEXIT_TR_WRITE=109,
	VMEXIT_RDTSC=110,
	VMEXIT_RDPMC=111,
	VMEXIT_PUSHF=112,
	VMEXIT_POPF=113,
	VMEXIT_CPUID=114,
	VMEXIT_RSM=115,
	VMEXIT_IRET=116,
	VMEXIT_SWINT=117,
	VMEXIT_INVD=118,
	VMEXIT_PAUSE=119,
	VMEXIT_HLT=120,
	VMEXIT_INVLPG=121,
	VMEXIT_INVLPGA=122,
	VMEXIT_IOIO=123,
	VMEXIT_MSR=124,
	VMEXIT_TASK_SWITCH=125,
	VMEXIT_FERR_FREEZE=126,
	VMEXIT_SHUTDOWN=127,

	VMEXIT_VMRUN=128,
	VMEXIT_VMMCALL=129,
	VMEXIT_VMLOAD=130,
	VMEXIT_VMSAVE=131,
	VMEXIT_STGI=132,
	VMEXIT_CLGI=133,
	VMEXIT_SKINIT=134,
	VMEXIT_RDTSCP=135,
	VMEXIT_ICEBP=136,
	VMEXIT_WBINVD=137,
	VMEXIT_MONITOR=138,
	VMEXIT_MWAIT=139,
	VMEXIT_MWAIT_CONDITIONAL=140,
	VMEXIT_XSETBV=141,

	VMEXIT_NPF=1024,
	AVIC_INCOMPLETE_IPI=1025,
	AVIC_NOACCEL=1026,

	VMEXIT_INVALID=-1
};

enum
{
	EVENTTYPE_INTR=0,
	EVENTTYPE_NMI=2,
	EVENTTYPE_EXCEPTION=3,
	EVENTTYPE_SWINT=4,
};

#pragma pack(push,1)

typedef struct
{
	ULONGLONG Vector:8;
	ULONGLONG Type:3;
	ULONGLONG CodeValid:1;
	ULONGLONG Reserved:19;
	ULONGLONG Valid:1;
	ULONGLONG ErrorCode:32;
} EXIT_INT_INFO;

typedef struct
{
	USHORT Selector;
	USHORT Attributes;
	ULONG Limit;
	ULONGLONG Base;
} SEG_REG_INFO;

typedef struct
{
	ULONG InterceptCR;
	ULONG InterceptDR;
	ULONG InterceptExceptions;
	ULONG InterceptGeneric1;
	ULONG InterceptGeneric2;
	ULONG Reserved1[10];
	USHORT PauseThreshold;
	USHORT PauseCount;
	ULONGLONG IOPMBasePA;
	ULONGLONG MSRPMBasePA;
	ULONGLONG TscOffset;
	ULONGLONG GuestASID:32;
	ULONGLONG TLBControl:8;
	ULONGLONG Reserved2:24;
	ULONGLONG VTPR:8;
	ULONGLONG VIRQ:1;
	ULONGLONG Reserved3:7;
	ULONGLONG VIntPrio:4;
	ULONGLONG VIgnTPR:1;
	ULONGLONG Reserved4:3;
	ULONGLONG VIntMasking:1;
	ULONGLONG Reserved5:6;
	ULONGLONG AVICEnable:1;
	ULONGLONG VIntVector:8;
	ULONGLONG Reserved6:24;
	ULONGLONG IntShadow:1;
	ULONGLONG Reserved7:63;
	ULONGLONG ExitCode;
	ULONGLONG ExitInfo1;
	ULONGLONG ExitInfo2;
	EXIT_INT_INFO ExitIntInfo;
	ULONGLONG NestedPagingEnable:1;
	ULONGLONG Reserved8:63;
	ULONGLONG AVICAPICBar:52;
	ULONGLONG Reserved9:12;
	ULONGLONG Reserved10;
	EXIT_INT_INFO EventInj;
	ULONGLONG GuestCr3;
	ULONGLONG LBRVirtualize:1;
	ULONGLONG Reserved11:63;
	ULONGLONG VMCBClean:32;
	ULONGLONG Reserved12:32;
	ULONGLONG NextRIP;
	UCHAR BytesNum;
	UCHAR Bytes[15];
	ULONGLONG AVICAPICBackingPagePtr:52;
	ULONGLONG Reserved13:12;
	ULONGLONG Reserved14;
	ULONGLONG AVICAPICLogicalTablePtr:52;
	ULONGLONG Reserved15:12;
	ULONGLONG AVICPhysMaxIndex:8;
	ULONGLONG Reserved16:4;
	ULONGLONG AVICAPICPhysTablePtr:40;
	ULONGLONG Reserved17:12;
	ULONGLONG Reserved18[96];

	SEG_REG_INFO Es;
	SEG_REG_INFO Cs;
	SEG_REG_INFO Ss;
	SEG_REG_INFO Ds;
	SEG_REG_INFO Fs;
	SEG_REG_INFO Gs;
	SEG_REG_INFO Gdtr;
	SEG_REG_INFO Ldtr;
	SEG_REG_INFO Idtr;
	SEG_REG_INFO Tr;
	UCHAR Reserved19[43];
	UCHAR Cpl;
	ULONG Reserved20;
	ULONGLONG Efer;
	ULONGLONG Reserved21[14];
	ULONGLONG Cr4;
	ULONGLONG Cr3;
	ULONGLONG Cr0;
	ULONGLONG Dr7;
	ULONGLONG Dr6;
	ULONGLONG RFlags;
	ULONGLONG Rip;
	ULONGLONG Reserved22[11];
	ULONGLONG Rsp;
	ULONGLONG Reserved23[3];
	ULONGLONG Rax;
	ULONGLONG Star;
	ULONGLONG LStar;
	ULONGLONG CStar;
	ULONGLONG SFMask;
	ULONGLONG KernelGsBase;
	ULONGLONG SysenterCs;
	ULONGLONG SysenterRsp;
	ULONGLONG SysenterRip;
	ULONGLONG Cr2;
	ULONGLONG Reserved24[4];
	ULONGLONG GuestPAT;
	ULONGLONG GuestDebugCtl;
	ULONGLONG GuestLastBranchFromIP;
	ULONGLONG GuestLastBranchToIP;
	ULONGLONG GuestLastIntFromIP;
	ULONGLONG GuestLastIntToIP;
} VMCB;

#pragma pack(pop)

#endif //SVM_H