#ifndef INTERFACE_H
#define INTERFACE_H

#define ENGINE_VERSION 0x040300

#define ENGINE_GETVERSION CTL_CODE(FILE_DEVICE_UNKNOWN,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define ENGINE_INIT CTL_CODE(FILE_DEVICE_UNKNOWN,0x801,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define ENGINE_HOOK CTL_CODE(FILE_DEVICE_UNKNOWN,0x802,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define ENGINE_EMULATE_RDTSC CTL_CODE(FILE_DEVICE_UNKNOWN,0x803,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define ENGINE_EMULATE_CPUID CTL_CODE(FILE_DEVICE_UNKNOWN,0x804,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define HOOK_NONE			0x00
#define HOOK_HOOK			0x01
#define HOOK_UNHOOK			0x02

#define STATE_READY			0x00
#define STATE_SINGLESTEP	0x01
#define STATE_BREAK			0x02
#define STATE_BREAKMEM		0x03
#define STATE_BREAKCPUID	0x04

#define STATE_HANDLED		0x10
#define STATE_UNHANDLED		0x11

#define STATE_BUSY			0x20

#pragma pack(push,1)

typedef struct
{
	ULONG Hook;
	ULONG Shift;
} RDTSC_HOOK;

typedef struct
{
	ULONG Hook;
} CPUID_HOOK;

typedef struct
{
	ULONG ProcessID;
	ULONG Int1;
	ULONG Int0d;
	ULONG Int0e;
} DATA_HOOK;

typedef struct
{
	ULONG State;
	ULONG ThreadID;

	ULONG_PTR RegCr2;
	ULONG_PTR RegDr0;
	ULONG_PTR RegDr1;
	ULONG_PTR RegDr2;
	ULONG_PTR RegDr3;
	ULONG_PTR RegDr6;
	ULONG_PTR RegDr7;

	ULONG_PTR RegIp;
	ULONG_PTR RegCS;
	ULONG_PTR RegFlags;
	ULONG_PTR RegSp;

	ULONG_PTR RegDi;
	ULONG_PTR RegSi;
	ULONG_PTR RegBp;
#if defined _M_IX86
	ULONG_PTR RegSp0;
#endif
	ULONG_PTR RegBx;
	ULONG_PTR RegDx;
	ULONG_PTR RegCx;
	ULONG_PTR RegAx;
#if defined _M_AMD64
	ULONG_PTR Reg8;
	ULONG_PTR Reg9;
	ULONG_PTR Reg10;
	ULONG_PTR Reg11;
	ULONG_PTR Reg12;
	ULONG_PTR Reg13;
	ULONG_PTR Reg14;
	ULONG_PTR Reg15;
#endif
} DATA_STATE;

#pragma pack(pop)

#endif //INTERFACE_H