# (c) Immunity Inc. 
# This is a port of Ero Carrera's script that he wrote for 
# IDAPython. This is the same deal, however it can be easily 
# expanded to track hits to these calls. The beauty of a debugger.
#
# http://www.openrce.org/blog/view/1077/Digging_up_system_call_ordinals
#
import getopt
from immlib import *

syscall_table = {'2003': 
 {'0x0103': 'NtSignalAndWaitForSingleObject',
 '0x009e': 'NtQueryInformationFile',
 '0x0079': 'NtOpenEventPair',
 '0x0078': 'NtOpenEvent',
 '0x00c9': 'NtReplaceKey',
 '0x0073': 'NtModifyDriverEntry',
 '0x0072': 'NtModifyBootEntry',
 '0x0071': 'NtMapViewOfSection',
 '0x0070': 'NtMapUserPhysicalPagesScatter',
 '0x0077': 'NtOpenDirectoryObject',
 '0x0076': 'NtNotifyChangeMultipleKeys',
 '0x0075': 'NtNotifyChangeKey',
 '0x0074': 'NtNotifyChangeDirectoryFile',
 '0x008f': 'NtProtectVirtualMemory',
 '0x00db': 'NtSetBootEntryOrder',
 '0x008d': 'NtPrivilegeObjectAuditAlarm',
 '0x008e': 'NtPrivilegedServiceAuditAlarm',
 '0x008b': 'NtPowerInformation',
 '0x008c': 'NtPrivilegeCheck',
 '0x008a': 'NtPlugPlayControl',
 '0x00ba': 'NtQueryVirtualMemory',
 '0x00bb': 'NtQueryVolumeInformationFile',
 '0x00bc': 'NtQueueApcThread',
 '0x00bd': 'NtRaiseException',
 '0x00be': 'NtRaiseHardError',
 '0x00bf': 'NtReadFile',
 '0x00da': 'NtSecureConnectPort',
 '0x00a9': 'NtQueryMutant',
 '0x00a8': 'NtQueryMultipleValueKey',
 '0x000f': 'NtAllocateLocallyUniqueId',
 '0x00a4': 'NtQueryInstallUILanguage',
 '0x000d': 'NtAlertResumeThread',
 '0x000e': 'NtAlertThread',
 '0x000b': 'NtAdjustGroupsToken',
 '0x000c': 'NtAdjustPrivilegesToken',
 '0x00a3': 'NtQueryInformationToken',
 '0x000a': 'NtAddDriverEntry',
 '0x00df': 'NtSetDefaultHardErrorPort',
 '0x00dd': 'NtSetContextThread',
 '0x007c': 'NtOpenJobObject',
 '0x007b': 'NtOpenIoCompletion',
 '0x007a': 'NtOpenFile',
 '0x00de': 'NtSetDebugFilterState',
 '0x007f': 'NtOpenObjectAuditAlarm',
 '0x007e': 'NtOpenMutant',
 '0x007d': 'NtOpenKey',
 '0x010f': 'NtUnloadDriver',
 '0x00c3': 'NtRegisterThreadTerminatePort',
 '0x0120': 'NtYieldExecution',
 '0x00f9': 'NtSetSystemInformation',
 '0x0008': 'NtAddAtom',
 '0x0009': 'NtAddBootEntry',
 '0x0006': 'NtAccessCheckByTypeResultListAndAuditAlarm',
 '0x0007': 'NtAccessCheckByTypeResultListAndAuditAlarmByHandle',
 '0x0004': 'NtAccessCheckByTypeAndAuditAlarm',
 '0x0005': 'NtAccessCheckByTypeResultList',
 '0x0002': 'NtAccessCheckAndAuditAlarm',
 '0x0003': 'NtAccessCheckByType',
 '0x0000': 'NtAcceptConnectPort',
 '0x0001': 'NtAccessCheck',
 '0x0086': 'NtOpenThread',
 '0x0087': 'NtOpenThreadToken',
 '0x0084': 'NtOpenSemaphore',
 '0x0085': 'NtOpenSymbolicLinkObject',
 '0x0082': 'NtOpenProcessTokenEx',
 '0x0083': 'NtOpenSection',
 '0x0080': 'NtOpenProcess',
 '0x0081': 'NtOpenProcessToken',
 '0x00b0': 'NtQuerySecurityObject',
 '0x00b1': 'NtQuerySemaphore',
 '0x00b2': 'NtQuerySymbolicLinkObject',
 '0x00b3': 'NtQuerySystemEnvironmentValue',
 '0x00b4': 'NtQuerySystemEnvironmentValueEx',
 '0x00b5': 'NtQuerySystemInformation',
 '0x0088': 'NtOpenThreadTokenEx',
 '0x0089': 'NtOpenTimer',
 '0x0109': 'NtTerminateJobObject',
 '0x00af': 'NtQuerySection',
 '0x00aa': 'NtQueryObject',
 '0x010d': 'NtTraceEvent',
 '0x00f1': 'NtSetIoCompletion',
 '0x00ac': 'NtQueryOpenSubKeysEx',
 '0x00ab': 'NtQueryOpenSubKeys',
 '0x00c7': 'NtRemoveProcessDebug',
 '0x00b8': 'NtQueryTimerResolution',
 '0x00c5': 'NtReleaseSemaphore',
 '0x00c4': 'NtReleaseMutant',
 '0x0019': 'NtCancelTimer',
 '0x0018': 'NtCancelIoFile',
 '0x00c1': 'NtReadRequestData',
 '0x00b9': 'NtQueryValueKey',
 '0x0015': 'NtAssignProcessToJobObject',
 '0x0014': 'NtAreMappedFilesTheSame',
 '0x0017': 'NtCancelDeviceWakeupRequest',
 '0x0016': 'NtCallbackReturn',
 '0x0011': 'NtAllocateUuids',
 '0x0010': 'NtAllocateUserPhysicalPages',
 '0x0013': 'NtApphelpCacheControl',
 '0x0012': 'NtAllocateVirtualMemory',
 '0x0095': 'NtQueryDefaultLocale',
 '0x0094': 'NtQueryDebugFilterState',
 '0x0097': 'NtQueryDirectoryFile',
 '0x0096': 'NtQueryDefaultUILanguage',
 '0x0091': 'NtQueryAttributesFile',
 '0x0090': 'NtPulseEvent',
 '0x0093': 'NtQueryBootOptions',
 '0x0092': 'NtQueryBootEntryOrder',
 '0x002a': 'NtCreateJobSet',
 '0x002b': 'NtCreateKey',
 '0x002c': 'NtCreateMailslotFile',
 '0x002d': 'NtCreateMutant',
 '0x002e': 'NtCreateNamedPipeFile',
 '0x002f': 'NtCreatePagingFile',
 '0x00ae': 'NtQueryQuotaInformationFile',
 '0x00c2': 'NtReadVirtualMemory',
 '0x0028': 'NtCreateIoCompletion',
 '0x0029': 'NtCreateJobObject',
 '0x00d0': 'NtRequestWaitReplyPort',
 '0x009f': 'NtQueryInformationJobObject',
 '0x009a': 'NtQueryEaFile',
 '0x00a0': 'NtQueryInformationPort',
 '0x009c': 'NtQueryFullAttributesFile',
 '0x009b': 'NtQueryEvent',
 '0x0020': 'NtCompressKey',
 '0x0021': 'NtConnectPort',
 '0x0022': 'NtContinue',
 '0x0023': 'NtCreateDebugObject',
 '0x0024': 'NtCreateDirectoryObject',
 '0x0025': 'NtCreateEvent',
 '0x0026': 'NtCreateEventPair',
 '0x0027': 'NtCreateFile',
 '0x00cf': 'NtRequestPort',
 '0x00ce': 'NtRequestDeviceWakeup',
 '0x00cd': 'NtReplyWaitReplyPort',
 '0x00cc': 'NtReplyWaitReceivePortEx',
 '0x00b6': 'NtQuerySystemTime',
 '0x00ca': 'NtReplyPort',
 '0x00e8': 'NtSetInformationDebugObject',
 '0x001e': 'NtCompareTokens',
 '0x001d': 'NtCompactKeys',
 '0x001f': 'NtCompleteConnectPort',
 '0x001a': 'NtClearEvent',
 '0x001c': 'NtCloseObjectAuditAlarm',
 '0x001b': 'NtClose',
 '0x004b': 'NtEnumerateKey',
 '0x004c': 'NtEnumerateSystemEnvironmentValuesEx',
 '0x004a': 'NtEnumerateDriverEntries',
 '0x004f': 'NtFilterToken',
 '0x011b': 'NtWaitLowEventPair',
 '0x004d': 'NtEnumerateValueKey',
 '0x004e': 'NtExtendSection',
 '0x0037': 'NtCreateThread',
 '0x0036': 'NtCreateSymbolicLinkObject',
 '0x0035': 'NtCreateSemaphore',
 '0x0034': 'NtCreateSection',
 '0x0033': 'NtCreateProfile',
 '0x0032': 'NtCreateProcessEx',
 '0x0031': 'NtCreateProcess',
 '0x0030': 'NtCreatePort',
 '0x0039': 'NtCreateToken',
 '0x0038': 'NtCreateTimer',
 '0x00e1': 'NtSetDefaultUILanguage',
 '0x00e0': 'NtSetDefaultLocale',
 '0x00e3': 'NtSetEaFile',
 '0x00e2': 'NtSetDriverEntryOrder',
 '0x00e5': 'NtSetEventBoostPriority',
 '0x00e4': 'NtSetEvent',
 '0x00e7': 'NtSetHighWaitLowEventPair',
 '0x00e6': 'NtSetHighEventPair',
 '0x00e9': 'NtSetInformationFile',
 'NA': 'NtWriteErrorLogEntry',
 '0x00f2': 'NtSetLdtEntries',
 '0x00fd': 'NtSetTimer',
 '0x00fe': 'NtSetTimerResolution',
 '0x00ff': 'NtSetUuidSeed',
 '0x0108': 'NtSystemDebugControl',
 '0x0102': 'NtShutdownSystem',
 '0x00fa': 'NtSetSystemPowerState',
 '0x00fb': 'NtSetSystemTime',
 '0x00fc': 'NtSetThreadExecutionState',
 '0x003f': 'NtDeleteBootEntry',
 '0x003e': 'NtDeleteAtom',
 '0x003d': 'NtDelayExecution',
 '0x003c': 'NtDebugContinue',
 '0x003b': 'NtDebugActiveProcess',
 '0x003a': 'NtCreateWaitablePort',
 '0x009d': 'NtQueryInformationAtom',
 '0x00d1': 'NtRequestWakeupLatency',
 '0x0042': 'NtDeleteKey',
 '0x0043': 'NtDeleteObjectAuditAlarm',
 '0x0040': 'NtDeleteDriverEntry',
 '0x0041': 'NtDeleteFile',
 '0x0046': 'NtDisplayString',
 '0x0047': 'NtDuplicateObject',
 '0x0044': 'NtDeleteValueKey',
 '0x0045': 'NtDeviceIoControlFile',
 '0x00d6': 'NtResumeThread',
 '0x0048': 'NtDuplicateToken',
 '0x0049': 'NtEnumerateBootEntries',
 '0x00a7': 'NtQueryKey',
 '0x00d7': 'NtSaveKey',
 '0x00a6': 'NtQueryIoCompletion',
 '0x00f8': 'NtSetSystemEnvironmentValueEx',
 '0x00d4': 'NtRestoreKey',
 '0x0125': 'NtQueryPortInformationProcess',
 '0x00a1': 'NtQueryInformationProcess',
 '0x00f6': 'NtSetSecurityObject',
 '0x0126': 'NtGetCurrentProcessorNumber',
 '0x0121': 'NtCreateKeyedEvent',
 '0x00d2': 'NtResetEvent',
 '0x0123': 'NtReleaseKeyedEvent',
 '0x0122': 'NtOpenKeyedEvent',
 '0x00ea': 'NtSetInformationJobObject',
 '0x00ec': 'NtSetInformationObject',
 '0x00eb': 'NtSetInformationKey',
 '0x00ee': 'NtSetInformationThread',
 '0x00ed': 'NtSetInformationProcess',
 '0x00f7': 'NtSetSystemEnvironmentValue',
 '0x00ef': 'NtSetInformationToken',
 '0x00a2': 'NtQueryInformationThread',
 '0x00d8': 'NtSaveKeyEx',
 '0x00f4': 'NtSetLowWaitHighEventPair',
 '0x010e': 'NtTranslateFilePath',
 '0x00d9': 'NtSaveMergedKeys',
 '0x010c': 'NtTestAlert',
 '0x010b': 'NtTerminateThread',
 '0x010a': 'NtTerminateProcess',
 '0x00a5': 'NtQueryIntervalProfile',
 '0x006d': 'NtMakePermanentObject',
 '0x006e': 'NtMakeTemporaryObject',
 '0x006f': 'NtMapUserPhysicalPages',
 '0x00d3': 'NtResetWriteWatch',
 '0x006a': 'NtLockProductActivationKeys',
 '0x006b': 'NtLockRegistryKey',
 '0x006c': 'NtLockVirtualMemory',
 '0x0051': 'NtFlushBuffersFile',
 '0x0050': 'NtFindAtom',
 '0x0053': 'NtFlushKey',
 '0x0052': 'NtFlushInstructionCache',
 '0x0055': 'NtFlushWriteBuffer',
 '0x0054': 'NtFlushVirtualMemory',
 '0x0057': 'NtFreeVirtualMemory',
 '0x0056': 'NtFreeUserPhysicalPages',
 '0x0059': 'NtGetContextThread',
 '0x0058': 'NtFsControlFile',
 '0x00c8': 'NtRenameKey',
 '0x00f5': 'NtSetQuotaInformationFile',
 '0x0118': 'NtWaitForMultipleObjects',
 '0x0119': 'NtWaitForSingleObject',
 '0x0124': 'NtWaitForKeyedEvent',
 '0x00d5': 'NtResumeProcess',
 '0x0110': 'NtUnloadKey',
 '0x0111': 'NtUnloadKey2',
 '0x00f3': 'NtSetLowEventPair',
 '0x0113': 'NtUnlockFile',
 '0x0114': 'NtUnlockVirtualMemory',
 '0x0115': 'NtUnmapViewOfSection',
 '0x0116': 'NtVdmControl',
 '0x0117': 'NtWaitForDebugEvent',
 '0x00cb': 'NtReplyWaitReceivePort',
 '0x005a': 'NtGetDevicePowerState',
 '0x005c': 'NtGetWriteWatch',
 '0x005b': 'NtGetPlugPlayEvent',
 '0x005e': 'NtImpersonateClientOfPort',
 '0x005d': 'NtImpersonateAnonymousToken',
 '0x005f': 'NtImpersonateThread',
 '0x011a': 'NtWaitHighEventPair',
 '0x0107': 'NtSuspendThread',
 '0x0106': 'NtSuspendProcess',
 '0x0105': 'NtStopProfile',
 '0x0099': 'NtQueryDriverEntryOrder',
 '0x0068': 'NtLoadKeyEx',
 '0x0069': 'NtLockFile',
 '0x0101': 'NtSetVolumeInformationFile',
 '0x0100': 'NtSetValueKey',
 '0x0064': 'NtListenPort',
 '0x0065': 'NtLoadDriver',
 '0x0066': 'NtLoadKey',
 '0x0067': 'NtLoadKey2',
 '0x0060': 'NtInitializeRegistry',
 '0x0061': 'NtInitiatePowerAction',
 '0x0062': 'NtIsProcessInJob',
 '0x0063': 'NtIsSystemResumeAutomatic',
 '0x00f0': 'NtSetIntervalProfile',
 '0x00dc': 'NtSetBootOptions',
 '0x00b7': 'NtQueryTimer',
 '0x0104': 'NtStartProfile',
 '0x011e': 'NtWriteRequestData',
 '0x0098': 'NtQueryDirectoryObject',
 '0x00c6': 'NtRemoveIoCompletion',
 '0x00c0': 'NtReadFileScatter',
 '0x011c': 'NtWriteFile',
 '0x011d': 'NtWriteFileGather',
 '0x0112': 'NtUnloadKeyEx',
 '0x011f': 'NtWriteVirtualMemory',
 '0x00ad': 'NtQueryPerformanceCounter'},
'2000': {
 '0x009e': 'NtQueueApcThread',
 '0x0079': 'NtQueryInformationAtom',
 '0x0078': 'NtPulseEvent',
 '0x00c9': 'NtSetIntervalProfile',
 '0x0073': 'NtPowerInformation',
 '0x0072': 'NtPlugPlayControl',
 '0x0071': 'NtOpenTimer',
 '0x0070': 'NtOpenThreadToken',
 '0x0077': 'NtProtectVirtualMemory',
 '0x0076': 'NtPrivilegeObjectAuditAlarm',
 '0x0075': 'NtPrivilegedServiceAuditAlarm',
 '0x0074': 'NtPrivilegeCheck',
 '0x008f': 'NtQueryOpenSubKeys',
 '0x00d3': 'NtSetThreadExecutionState',
 '0x008d': 'NtQueryMutant',
 '0x008e': 'NtQueryObject',
 '0x008b': 'NtQueryKey',
 '0x008c': 'NtQueryMultipleValueKey',
 '0x008a': 'NtQueryIntervalProfile',
 '0x00ba': 'NtSetContextThread',
 '0x00bb': 'NtSetDefaultHardErrorPort',
 '0x00bc': 'NtSetDefaultLocale',
 '0x00bd': 'NtSetDefaultUILanguage',
 '0x00be': 'NtSetEaFile',
 '0x00bf': 'NtSetEvent',
 '0x00da': 'NtSignalAndWaitForSingleObject',
 '0x00a9': 'NtReplaceKey',
 '0x00a8': 'NtRemoveIoCompletion',
 '0x000f': 'NtAllocateUuids',
 '0x00a4': 'NtReadVirtualMemory',
 '0x000d': 'NtAllocateLocallyUniqueId',
 '0x000e': 'NtAllocateUserPhysicalPages',
 '0x000b': 'NtAlertResumeThread',
 '0x000c': 'NtAlertThread',
 '0x00a3': 'NtReadRequestData',
 '0x000a': 'NtAdjustPrivilegesToken',
 '0x00df': 'NtTerminateJobObject',
 '0x00dd': 'NtSuspendThread',
 '0x00b9': 'NtSetIoCompletion',
 '0x007c': 'NtQueryDefaultUILanguage',
 '0x007b': 'NtQueryDefaultLocale',
 '0x007a': 'NtQueryAttributesFile',
 '0x00de': 'NtSystemDebugControl',
 '0x007f': 'NtQueryEaFile',
 '0x007e': 'NtQueryDirectoryObject',
 '0x007d': 'NtQueryDirectoryFile',
 '0x00c3': 'NtSetInformationJobObject',
 '0x0008': 'NtAddAtom',
 '0x0009': 'NtAdjustGroupsToken',
 '0x0006': 'NtAccessCheckByTypeResultListAndAuditAlarm',
 '0x0007': 'NtAccessCheckByTypeResultListAndAuditAlarmByHandle',
 '0x0004': 'NtAccessCheckByTypeAndAuditAlarm',
 '0x0005': 'NtAccessCheckByTypeResultList',
 '0x0002': 'NtAccessCheckAndAuditAlarm',
 '0x0003': 'NtAccessCheckByType',
 '0x0000': 'NtAcceptConnectPort',
 '0x0001': 'NtAccessCheck',
 '0x0086': 'NtQueryInformationProcess',
 '0x0087': 'NtQueryInformationThread',
 '0x0084': 'NtQueryIoCompletion',
 '0x0085': 'NtQueryInformationPort',
 '0x0082': 'NtQueryInformationFile',
 '0x0083': 'NtQueryInformationJobObject',
 '0x0080': 'NtQueryEvent',
 '0x0081': 'NtQueryFullAttributesFile',
 '0x00b0': 'NtRequestWaitReplyPort',
 '0x00b1': 'NtRequestWakeupLatency',
 '0x00b2': 'NtResetEvent',
 '0x00b3': 'NtResetWriteWatch',
 '0x00b4': 'NtRestoreKey',
 '0x00b5': 'NtResumeThread',
 '0x0088': 'NtQueryInformationToken',
 '0x0089': 'NtQueryInstallUILanguage',
 '0x00af': 'NtRequestPort',
 '0x00aa': 'NtReplyPort',
 '0x00ac': 'NtReplyWaitReceivePortEx',
 '0x00ab': 'NtReplyWaitReceivePort',
 '0x00c7': 'NtSetInformationThread',
 '0x00b8': 'NtSecureConnectPort',
 '0x00c5': 'NtSetInformationObject',
 '0x00c4': 'NtSetInformationKey',
 '0x0019': 'NtCloseObjectAuditAlarm',
 '0x0018': 'NtClose',
 '0x00c1': 'NtSetHighWaitLowEventPair',
 '0x00c0': 'NtSetHighEventPair',
 '0x0015': 'NtCancelTimer',
 '0x0014': 'NtCancelIoFile',
 '0x0017': 'NtClearEvent',
 '0x0016': 'NtCancelDeviceWakeupRequest',
 '0x0011': 'NtAreMappedFilesTheSame',
 '0x0010': 'NtAllocateVirtualMemory',
 '0x0013': 'NtCallbackReturn',
 '0x0012': 'NtAssignProcessToJobObject',
 '0x0095': 'NtQuerySymbolicLinkObject',
 '0x0094': 'NtQuerySemaphore',
 '0x0097': 'NtQuerySystemInformation',
 '0x0096': 'NtQuerySystemEnvironmentValue',
 '0x0091': 'NtQueryQuotaInformationFile',
 '0x0090': 'NtQueryPerformanceCounter',
 '0x0093': 'NtQuerySecurityObject',
 '0x0092': 'NtQuerySection',
 '0x002a': 'NtCreateProfile',
 '0x002b': 'NtCreateSection',
 '0x002c': 'NtCreateSemaphore',
 '0x002d': 'NtCreateSymbolicLinkObject',
 '0x002e': 'NtCreateThread',
 '0x002f': 'NtCreateTimer',
 '0x00ae': 'NtRequestDeviceWakeup',
 '0x00c2': 'NtSetInformationFile',
 '0x0028': 'NtCreatePort',
 '0x0029': 'NtCreateProcess',
 '0x00d0': 'NtSetSystemInformation',
 '0x009f': 'NtRaiseException',
 '0x009a': 'NtQueryTimerResolution',
 '0x00a0': 'NtRaiseHardError',
 '0x009c': 'NtQueryVirtualMemory',
 '0x009b': 'NtQueryValueKey',
 '0x0020': 'NtCreateFile',
 '0x0021': 'NtCreateIoCompletion',
 '0x0022': 'NtCreateJobObject',
 '0x0023': 'NtCreateKey',
 '0x0024': 'NtCreateMailslotFile',
 '0x0025': 'NtCreateMutant',
 '0x0026': 'NtCreateNamedPipeFile',
 '0x0027': 'NtCreatePagingFile',
 '0x00cf': 'NtSetSystemEnvironmentValue',
 '0x00ce': 'NtSetSecurityObject',
 '0x00cd': 'NtSetQuotaInformationFile',
 '0x00cc': 'NtSetLowWaitHighEventPair',
 '0x00b6': 'NtSaveKey',
 '0x00ca': 'NtSetLdtEntries',
 '0x00e8': 'NtVdmControl',
 '0x001e': 'NtCreateEvent',
 '0x001d': 'NtCreateDirectoryObject',
 '0x001f': 'NtCreateEventPair',
 '0x001a': 'NtCompleteConnectPort',
 '0x001c': 'NtContinue',
 '0x001b': 'NtConnectPort',
 '0x004b': 'NtGetPlugPlayEvent',
 '0x004c': 'NtGetTickCount',
 '0x004a': 'NtGetDevicePowerState',
 '0x004f': 'NtImpersonateClientOfPort',
 '0x004d': 'NtGetWriteWatch',
 '0x004e': 'NtImpersonateAnonymousToken',
 '0x0037': 'NtDeleteValueKey',
 '0x0036': 'NtDeleteObjectAuditAlarm',
 '0x0035': 'NtDeleteKey',
 '0x0034': 'NtDeleteFile',
 '0x0033': 'NtDeleteAtom',
 '0x0032': 'NtDelayExecution',
 '0x0031': 'NtCreateWaitablePort',
 '0x0030': 'NtCreateToken',
 '0x0039': 'NtDisplayString',
 '0x0038': 'NtDeviceIoControlFile',
 '0x00e1': 'NtTerminateThread',
 '0x00e0': 'NtTerminateProcess',
 '0x00e3': 'NtUnloadDriver',
 '0x00e2': 'NtTestAlert',
 '0x00e5': 'NtUnlockFile',
 '0x00e4': 'NtUnloadKey',
 '0x00e7': 'NtUnmapViewOfSection',
 '0x00e6': 'NtUnlockVirtualMemory',
 '0x00e9': 'NtWaitForMultipleObjects',
 'NA': 'NtWriteErrorLogEntry',
 '0x003f': 'NtFilterToken',
 '0x003e': 'NtExtendSection',
 '0x003d': 'NtEnumerateValueKey',
 '0x003c': 'NtEnumerateKey',
 '0x003b': 'NtDuplicateToken',
 '0x003a': 'NtDuplicateObject',
 '0x009d': 'NtQueryVolumeInformationFile',
 '0x00d1': 'NtSetSystemPowerState',
 '0x0042': 'NtFlushInstructionCache',
 '0x0043': 'NtFlushKey',
 '0x0040': 'NtFindAtom',
 '0x0041': 'NtFlushBuffersFile',
 '0x0046': 'NtFreeUserPhysicalPages',
 '0x0047': 'NtFreeVirtualMemory',
 '0x0044': 'NtFlushVirtualMemory',
 '0x0045': 'NtFlushWriteBuffer',
 '0x00d6': 'NtSetUuidSeed',
 '0x0048': 'NtFsControlFile',
 '0x0049': 'NtGetContextThread',
 '0x00a7': 'NtReleaseSemaphore',
 '0x00d7': 'NtSetValueKey',
 '0x00a6': 'NtReleaseMutant',
 '0x00d4': 'NtSetTimer',
 '0x00f4': 'NtReplyWaitSendChannel',
 '0x00a1': 'NtReadFile',
 '0x00f6': 'NtSetContextChannel',
 '0x00d5': 'NtSetTimerResolution',
 '0x00f0': 'NtWriteVirtualMemory',
 '0x00f1': 'NtCreateChannel',
 '0x00f2': 'NtListenChannel',
 '0x00f3': 'NtOpenChannel',
 '0x00ea': 'NtWaitForSingleObject',
 '0x00ec': 'NtWaitLowEventPair',
 '0x00eb': 'NtWaitHighEventPair',
 '0x00ee': 'NtWriteFileGather',
 '0x00ed': 'NtWriteFile',
 '0x00f7': 'NtYieldExecution',
 '0x00ef': 'NtWriteRequestData',
 '0x00a2': 'NtReadFileScatter',
 '0x00d8': 'NtSetVolumeInformationFile',
 '0x00d9': 'NtShutdownSystem',
 '0x00a5': 'NtRegisterThreadTerminatePort',
 '0x006d': 'NtOpenSemaphore',
 '0x006e': 'NtOpenSymbolicLinkObject',
 '0x006f': 'NtOpenThread',
 '0x00d2': 'NtSetSystemTime',
 '0x006a': 'NtOpenProcess',
 '0x006b': 'NtOpenProcessToken',
 '0x006c': 'NtOpenSection',
 '0x0051': 'NtInitializeRegistry',
 '0x0050': 'NtImpersonateThread',
 '0x0053': 'NtIsSystemResumeAutomatic',
 '0x0052': 'NtInitiatePowerAction',
 '0x0055': 'NtLoadDriver',
 '0x0054': 'NtListenPort',
 '0x0057': 'NtLoadKey2',
 '0x0056': 'NtLoadKey',
 '0x0059': 'NtLockVirtualMemory',
 '0x0058': 'NtLockFile',
 '0x00c8': 'NtSetInformationToken',
 '0x00f5': 'NtSendWaitReplyChannel',
 '0x00cb': 'NtSetLowEventPair',
 '0x005a': 'NtMakeTemporaryObject',
 '0x005c': 'NtMapUserPhysicalPagesScatter',
 '0x005b': 'NtMapUserPhysicalPages',
 '0x005e': 'NtNotifyChangeDirectoryFile',
 '0x005d': 'NtMapViewOfSection',
 '0x005f': 'NtNotifyChangeKey',
 '0x00db': 'NtStartProfile',
 '0x0099': 'NtQueryTimer',
 '0x0068': 'NtOpenMutant',
 '0x0069': 'NtOpenObjectAuditAlarm',
 '0x0064': 'NtOpenFile',
 '0x0065': 'NtOpenIoCompletion',
 '0x0066': 'NtOpenJobObject',
 '0x0067': 'NtOpenKey',
 '0x0060': 'NtNotifyChangeMultipleKeys',
 '0x0061': 'NtOpenDirectoryObject',
 '0x0062': 'NtOpenEvent',
 '0x0063': 'NtOpenEventPair',
 '0x00dc': 'NtStopProfile',
 '0x00b7': 'NtSaveMergedKeys',
 '0x0098': 'NtQuerySystemTime',
 '0x00c6': 'NtSetInformationProcess',
 '0x00ad': 'NtReplyWaitReplyPort'},
'NT':{
 '0x009e': 'NtSetHighEventPair',
 '0x0079': 'NtQuerySemaphore',
 '0x0078': 'NtQuerySecurityObject',
 '0x00c9': 'NtWriteFileGather',
 '0x0073': 'NtQueryMutant',
 '0x0072': 'NtQueryMultipleValueKey',
 '0x0071': 'NtQueryKey',
 '0x0070': 'NtQueryIntervalProfile',
 '0x0077': 'NtQuerySection',
 '0x0076': 'NtQueryPerformanceCounter',
 '0x0075': 'NtQueryOleDirectoryFile',
 '0x0074': 'NtQueryObject',
 '0x008f': 'NtReplyPort',
 '0x008d': 'NtRemoveIoCompletion',
 '0x008e': 'NtReplaceKey',
 '0x008b': 'NtReleaseMutant',
 '0x008c': 'NtReleaseSemaphore',
 '0x008a': 'NtRegisterThreadTerminatePort',
 '0x00ba': 'NtSystemDebugControl',
 '0x00bb': 'NtTerminateProcess',
 '0x00bc': 'NtTerminateThread',
 '0x00bd': 'NtTestAlert',
 '0x00be': 'NtUnloadDriver',
 '0x00bf': 'NtUnloadKey',
 '0x00a9': 'NtSetLowEventPair',
 '0x00a8': 'NtSetLdtEntries',
 '0x000f': 'NtClose',
 '0x00a4': 'NtSetInformationProcess',
 '0x000d': 'NtCancelTimer',
 '0x000e': 'NtClearEvent',
 '0x000b': 'NtCallbackReturn',
 '0x000c': 'NtCancelIoFile',
 '0x00a3': 'NtSetInformationObject',
 '0x000a': 'NtAllocateVirtualMemory',
 '0x007c': 'NtQuerySystemInformation',
 '0x007b': 'NtQuerySystemEnvironmentValue',
 '0x007a': 'NtQuerySymbolicLinkObject',
 '0x007f': 'NtQueryTimerResolution',
 '0x007e': 'NtQueryTimer',
 '0x007d': 'NtQuerySystemTime',
 '0x00c3': 'NtVdmControl',
 '0x0008': 'NtAllocateLocallyUniqueId',
 '0x0009': 'NtAllocateUuids',
 '0x0006': 'NtAlertResumeThread',
 '0x0007': 'NtAlertThread',
 '0x0004': 'NtAdjustGroupsToken',
 '0x0005': 'NtAdjustPrivilegesToken',
 '0x0002': 'NtAccessCheckAndAuditAlarm',
 '0x0003': 'NtAddAtom',
 '0x0000': 'NtAcceptConnectPort',
 '0x0001': 'NtAccessCheck',
 '0x0086': 'NtReadFile',
 '0x0087': 'NtReadFileScatter',
 '0x0084': 'NtRaiseException',
 '0x0085': 'NtRaiseHardError',
 '0x0082': 'NtQueryVolumeInformationFile',
 '0x0083': 'NtQueueApcThread',
 '0x0080': 'NtQueryValueKey',
 '0x0081': 'NtQueryVirtualMemory',
 '0x00b0': 'NtSetSystemTime',
 '0x00b1': 'NtSetTimer',
 '0x00b2': 'NtSetTimerResolution',
 '0x00b3': 'NtSetValueKey',
 '0x00b4': 'NtSetVolumeInformationFile',
 '0x00b5': 'NtShutdownSystem',
 '0x0088': 'NtReadRequestData',
 '0x0089': 'NtReadVirtualMemory',
 '0x00af': 'NtSetSystemPowerState',
 '0x00aa': 'NtSetLowWaitHighEventPair',
 '0x00ac': 'NtSetSecurityObject',
 '0x00ab': 'NtSetLowWaitHighThread',
 '0x00c7': 'NtWaitLowEventPair',
 '0x00b8': 'NtStopProfile',
 '0x00c5': 'NtWaitForSingleObject',
 '0x00c4': 'NtWaitForMultipleObjects',
 '0x0019': 'NtCreateKey',
 '0x0018': 'NtCreateIoCompletion',
 '0x00c1': 'NtUnlockVirtualMemory',
 '0x00b9': 'NtSuspendThread',
 '0x0015': 'NtCreateEvent',
 '0x0014': 'NtCreateDirectoryObject',
 '0x0017': 'NtCreateFile',
 '0x0016': 'NtCreateEventPair',
 '0x0011': 'NtCompleteConnectPort',
 '0x0010': 'NtCloseObjectAuditAlarm',
 '0x0013': 'NtContinue',
 '0x0012': 'NtConnectPort',
 '0x0095': 'NtRestoreKey',
 '0x0094': 'NtResetEvent',
 '0x0097': 'NtSaveKey',
 '0x0096': 'NtResumeThread',
 '0x0091': 'NtReplyWaitReplyPort',
 '0x0090': 'NtReplyWaitReceivePort',
 '0x0093': 'NtRequestWaitReplyPort',
 '0x0092': 'NtRequestPort',
 '0x002a': 'NtDeleteKey',
 '0x002b': 'NtDeleteObjectAuditAlarm',
 '0x002c': 'NtDeleteValueKey',
 '0x002d': 'NtDeviceIoControlFile',
 '0x002e': 'NtDisplayString',
 '0x002f': 'NtDuplicateObject',
 '0x00ae': 'NtSetSystemInformation',
 '0x00c2': 'NtUnmapViewOfSection',
 '0x0028': 'NtDeleteAtom',
 '0x0029': 'NtDeleteFile',
 '0x00d0': 'NtReplyWaitSendChannel',
 '0x00d1': 'NtSendWaitReplyChannel',
 '0x009a': 'NtSetDefaultHardErrorPort',
 '0x009c': 'NtSetEaFile',
 '0x009b': 'NtSetDefaultLocale',
 '0x0020': 'NtCreateProfile',
 '0x0021': 'NtCreateSection',
 '0x0022': 'NtCreateSemaphore',
 '0x0023': 'NtCreateSymbolicLinkObject',
 '0x0024': 'NtCreateThread',
 '0x0025': 'NtCreateTimer',
 '0x0026': 'NtCreateToken',
 '0x0027': 'NtDelayExecution',
 '0x00cf': 'NtOpenChannel',
 '0x00ce': 'NtListenChannel',
 '0x00cd': 'NtCreateChannel',
 '0x00cc': 'NtW32Call',
 '0x00b6': 'NtSignalAndWaitForSingleObject',
 '0x00ca': 'NtWriteRequestData',
 '0x001e': 'NtCreatePort',
 '0x001d': 'NtCreatePagingFile',
 '0x001f': 'NtCreateProcess',
 '0x001a': 'NtCreateMailslotFile',
 '0x001c': 'NtCreateNamedPipeFile',
 '0x001b': 'NtCreateMutant',
 '0x004b': 'NtNotifyChangeKey',
 '0x004c': 'NtOpenDirectoryObject',
 '0x004a': 'NtNotifyChangeDirectoryFile',
 '0x004f': 'NtOpenFile',
 '0x004d': 'NtOpenEvent',
 '0x004e': 'NtOpenEventPair',
 '0x0037': 'NtFlushKey',
 '0x0036': 'NtFlushInstructionCache',
 '0x0035': 'NtFlushBuffersFile',
 '0x0034': 'NtFindAtom',
 '0x0033': 'NtExtendSection',
 '0x0032': 'NtEnumerateValueKey',
 '0x0031': 'NtEnumerateKey',
 '0x0030': 'NtDuplicateToken',
 '0x0039': 'NtFlushWriteBuffer',
 '0x0038': 'NtFlushVirtualMemory',
 'NA': 'NtWriteErrorLogEntry',
 '0x003f': 'NtImpersonateClientOfPort',
 '0x003e': 'NtGetTickCount',
 '0x003d': 'NtGetPlugPlayEvent',
 '0x003c': 'NtGetContextThread',
 '0x003b': 'NtFsControlFile',
 '0x003a': 'NtFreeVirtualMemory',
 '0x009d': 'NtSetEvent',
 '0x0042': 'NtListenPort',
 '0x0043': 'NtLoadDriver',
 '0x0040': 'NtImpersonateThread',
 '0x0041': 'NtInitializeRegistry',
 '0x0046': 'NtLockFile',
 '0x0047': 'NtLockVirtualMemory',
 '0x0044': 'NtLoadKey',
 '0x0045': 'NtLoadKey2',
 '0x0048': 'NtMakeTemporaryObject',
 '0x0049': 'NtMapViewOfSection',
 '0x00a7': 'NtSetIntervalProfile',
 '0x00a6': 'NtSetInformationToken',
 '0x00a1': 'NtSetInformationFile',
 '0x00d2': 'NtSetContextChannel',
 '0x00a0': 'NtSetHighWaitLowThread',
 '0x00a2': 'NtSetInformationKey',
 '0x00a5': 'NtSetInformationThread',
 '0x006d': 'NtQueryInformationProcess',
 '0x006e': 'NtQueryInformationThread',
 '0x006f': 'NtQueryInformationToken',
 '0x00d3': 'NtYieldExecution',
 '0x006a': 'NtQueryInformationFile',
 '0x006b': 'NtQueryIoCompletion',
 '0x006c': 'NtQueryInformationPort',
 '0x0051': 'NtOpenKey',
 '0x0050': 'NtOpenIoCompletion',
 '0x0053': 'NtOpenObjectAuditAlarm',
 '0x0052': 'NtOpenMutant',
 '0x0055': 'NtOpenProcessToken',
 '0x0054': 'NtOpenProcess',
 '0x0057': 'NtOpenSemaphore',
 '0x0056': 'NtOpenSection',
 '0x0059': 'NtOpenThread',
 '0x0058': 'NtOpenSymbolicLinkObject',
 '0x00c8': 'NtWriteFile',
 '0x00cb': 'NtWriteVirtualMemory',
 '0x005a': 'NtOpenThreadToken',
 '0x005c': 'NtPlugPlayControl',
 '0x005b': 'NtOpenTimer',
 '0x005e': 'NtPrivilegedServiceAuditAlarm',
 '0x005d': 'NtPrivilegeCheck',
 '0x005f': 'NtPrivilegeObjectAuditAlarm',
 '0x0099': 'NtSetContextThread',
 '0x0068': 'NtQueryEvent',
 '0x0069': 'NtQueryFullAttributesFile',
 '0x009f': 'NtSetHighWaitLowEventPair',
 '0x0064': 'NtQueryDefaultLocale',
 '0x0065': 'NtQueryDirectoryFile',
 '0x0066': 'NtQueryDirectoryObject',
 '0x0067': 'NtQueryEaFile',
 '0x0060': 'NtProtectVirtualMemory',
 '0x0061': 'NtPulseEvent',
 '0x0062': 'NtQueryInformationAtom',
 '0x0063': 'NtQueryAttributesFile',
 '0x00b7': 'NtStartProfile',
 '0x0098': 'NtSetIoCompletion',
 '0x00c6': 'NtWaitHighEventPair',
 '0x00c0': 'NtUnlockFile',
 '0x00ad': 'NtSetSystemEnvironmentValue'},
'XP': {
 '0x0103': 'NtTestAlert',
 '0x009e': 'NtQueryIntervalProfile',
 '0x0079': 'NtOpenObjectAuditAlarm',
 '0x0078': 'NtOpenMutant',
 '0x00c9': 'NtRequestWakeupLatency',
 '0x0073': 'NtOpenEventPair',
 '0x0072': 'NtOpenEvent',
 '0x0071': 'NtOpenDirectoryObject',
 '0x0070': 'NtNotifyChangeMultipleKeys',
 '0x0077': 'NtOpenKey',
 '0x0076': 'NtOpenJobObject',
 '0x0075': 'NtOpenIoCompletion',
 '0x0074': 'NtOpenFile',
 '0x008f': 'NtQueryDefaultLocale',
 '0x00db': 'NtSetEvent',
 '0x008d': 'NtQueryBootOptions',
 '0x008e': 'NtQueryDebugFilterState',
 '0x008b': 'NtQueryAttributesFile',
 '0x008c': 'NtQueryBootEntryOrder',
 '0x008a': 'NtPulseEvent',
 '0x00ba': 'NtReadVirtualMemory',
 '0x00bb': 'NtRegisterThreadTerminatePort',
 '0x00bc': 'NtReleaseMutant',
 '0x00bd': 'NtReleaseSemaphore',
 '0x00be': 'NtRemoveIoCompletion',
 '0x00bf': 'NtRemoveProcessDebug',
 '0x00da': 'NtSetEaFile',
 '0x00a9': 'NtQuerySemaphore',
 '0x00a8': 'NtQuerySecurityObject',
 '0x000f': 'NtAllocateUserPhysicalPages',
 '0x00a4': 'NtQueryOpenSubKeys',
 '0x000d': 'NtAlertThread',
 '0x000e': 'NtAllocateLocallyUniqueId',
 '0x000b': 'NtAdjustPrivilegesToken',
 '0x000c': 'NtAlertResumeThread',
 '0x00a3': 'NtQueryObject',
 '0x000a': 'NtAdjustGroupsToken',
 '0x00c0': 'NtRenameKey',
 '0x00df': 'NtSetInformationDebugObject',
 '0x00dd': 'NtSetHighEventPair',
 '0x007c': 'NtOpenProcessTokenEx',
 '0x007b': 'NtOpenProcessToken',
 '0x007a': 'NtOpenProcess',
 '0x00de': 'NtSetHighWaitLowEventPair',
 '0x007f': 'NtOpenSymbolicLinkObject',
 '0x007e': 'NtOpenSemaphore',
 '0x007d': 'NtOpenSection',
 '0x00c3': 'NtReplyWaitReceivePort',
 '0x00f9': 'NtShutdownSystem',
 '0x0008': 'NtAddAtom',
 '0x0009': 'NtAddBootEntry',
 '0x0006': 'NtAccessCheckByTypeResultListAndAuditAlarm',
 '0x0007': 'NtAccessCheckByTypeResultListAndAuditAlarmByHandle',
 '0x0004': 'NtAccessCheckByTypeAndAuditAlarm',
 '0x0005': 'NtAccessCheckByTypeResultList',
 '0x0002': 'NtAccessCheckAndAuditAlarm',
 '0x0003': 'NtAccessCheckByType',
 '0x0000': 'NtAcceptConnectPort',
 '0x0001': 'NtAccessCheck',
 '0x0086': 'NtPrivilegeCheck',
 '0x0087': 'NtPrivilegeObjectAuditAlarm',
 '0x0084': 'NtPlugPlayControl',
 '0x0085': 'NtPowerInformation',
 '0x0082': 'NtOpenThreadTokenEx',
 '0x0083': 'NtOpenTimer',
 '0x0080': 'NtOpenThread',
 '0x0081': 'NtOpenThreadToken',
 '0x00b0': 'NtQueryTimerResolution',
 '0x00b1': 'NtQueryValueKey',
 '0x00b2': 'NtQueryVirtualMemory',
 '0x00b3': 'NtQueryVolumeInformationFile',
 '0x00b4': 'NtQueueApcThread',
 '0x00b5': 'NtRaiseException',
 '0x0088': 'NtPrivilegedServiceAuditAlarm',
 '0x0089': 'NtProtectVirtualMemory',
 '0x00af': 'NtQueryTimer',
 '0x00aa': 'NtQuerySymbolicLinkObject',
 '0x010d': 'NtWaitForDebugEvent',
 '0x00f1': 'NtSetSystemPowerState',
 '0x00ac': 'NtQuerySystemEnvironmentValueEx',
 '0x00ab': 'NtQuerySystemEnvironmentValue',
 '0x00c7': 'NtRequestPort',
 '0x00b8': 'NtReadFileScatter',
 '0x00c5': 'NtReplyWaitReplyPort',
 '0x00c4': 'NtReplyWaitReceivePortEx',
 '0x0019': 'NtClose',
 '0x0018': 'NtClearEvent',
 '0x00c1': 'NtReplaceKey',
 '0x00b9': 'NtReadRequestData',
 '0x0015': 'NtCancelDeviceWakeupRequest',
 '0x0014': 'NtCallbackReturn',
 '0x0017': 'NtCancelTimer',
 '0x0016': 'NtCancelIoFile',
 '0x0011': 'NtAllocateVirtualMemory',
 '0x0010': 'NtAllocateUuids',
 '0x0013': 'NtAssignProcessToJobObject',
 '0x0012': 'NtAreMappedFilesTheSame',
 '0x0095': 'NtQueryFullAttributesFile',
 '0x0094': 'NtQueryEvent',
 '0x0097': 'NtQueryInformationFile',
 '0x0096': 'NtQueryInformationAtom',
 '0x0091': 'NtQueryDirectoryFile',
 '0x0090': 'NtQueryDefaultUILanguage',
 '0x0093': 'NtQueryEaFile',
 '0x0092': 'NtQueryDirectoryObject',
 '0x002a': 'NtCreateMailslotFile',
 '0x002b': 'NtCreateMutant',
 '0x002c': 'NtCreateNamedPipeFile',
 '0x002d': 'NtCreatePagingFile',
 '0x002e': 'NtCreatePort',
 '0x002f': 'NtCreateProcess',
 '0x00ae': 'NtQuerySystemTime',
 '0x00c2': 'NtReplyPort',
 '0x0028': 'NtCreateJobSet',
 '0x0029': 'NtCreateKey',
 '0x00d0': 'NtSaveKeyEx',
 '0x009f': 'NtQueryIoCompletion',
 '0x009a': 'NtQueryInformationProcess',
 '0x00d7': 'NtSetDefaultHardErrorPort',
 '0x009c': 'NtQueryInformationToken',
 '0x009b': 'NtQueryInformationThread',
 '0x0020': 'NtContinue',
 '0x0021': 'NtCreateDebugObject',
 '0x0022': 'NtCreateDirectoryObject',
 '0x0023': 'NtCreateEvent',
 '0x0024': 'NtCreateEventPair',
 '0x0025': 'NtCreateFile',
 '0x0026': 'NtCreateIoCompletion',
 '0x0027': 'NtCreateJobObject',
 '0x00cf': 'NtSaveKey',
 '0x00ce': 'NtResumeThread',
 '0x00cd': 'NtResumeProcess',
 '0x00cc': 'NtRestoreKey',
 '0x00b6': 'NtRaiseHardError',
 '0x00ca': 'NtResetEvent',
 '0x00e8': 'NtSetIoCompletion',
 '0x001e': 'NtCompressKey',
 '0x001d': 'NtCompleteConnectPort',
 '0x001f': 'NtConnectPort',
 '0x001a': 'NtCloseObjectAuditAlarm',
 '0x001c': 'NtCompareTokens',
 '0x001b': 'NtCompactKeys',
 '0x004b': 'NtFilterToken',
 '0x004c': 'NtFindAtom',
 '0x004a': 'NtExtendSection',
 '0x004f': 'NtFlushKey',
 '0x004d': 'NtFlushBuffersFile',
 '0x004e': 'NtFlushInstructionCache',
 '0x0037': 'NtCreateToken',
 '0x0036': 'NtCreateTimer',
 '0x0035': 'NtCreateThread',
 '0x0034': 'NtCreateSymbolicLinkObject',
 '0x0033': 'NtCreateSemaphore',
 '0x0032': 'NtCreateSection',
 '0x0031': 'NtCreateProfile',
 '0x0030': 'NtCreateProcessEx',
 '0x0039': 'NtDebugActiveProcess',
 '0x0038': 'NtCreateWaitablePort',
 '0x00e1': 'NtSetInformationJobObject',
 '0x00e0': 'NtSetInformationFile',
 '0x00e3': 'NtSetInformationObject',
 '0x00e2': 'NtSetInformationKey',
 '0x00e5': 'NtSetInformationThread',
 '0x00e4': 'NtSetInformationProcess',
 '0x00e7': 'NtSetIntervalProfile',
 '0x00e6': 'NtSetInformationToken',
 '0x00e9': 'NtSetLdtEntries',
 'NA': 'NtWriteErrorLogEntry',
 '0x0109': 'NtUnlockFile',
 '0x00fd': 'NtSuspendProcess',
 '0x00fe': 'NtSuspendThread',
 '0x00ff': 'NtSystemDebugControl',
 '0x0108': 'NtUnloadKeyEx',
 '0x0102': 'NtTerminateThread',
 '0x00fa': 'NtSignalAndWaitForSingleObject',
 '0x00fb': 'NtStartProfile',
 '0x00fc': 'NtStopProfile',
 '0x003f': 'NtDeleteKey',
 '0x003e': 'NtDeleteFile',
 '0x003d': 'NtDeleteBootEntry',
 '0x003c': 'NtDeleteAtom',
 '0x003b': 'NtDelayExecution',
 '0x003a': 'NtDebugContinue',
 '0x009d': 'NtQueryInstallUILanguage',
 '0x00d1': 'NtSaveMergedKeys',
 '0x0042': 'NtDeviceIoControlFile',
 '0x0043': 'NtDisplayString',
 '0x0040': 'NtDeleteObjectAuditAlarm',
 '0x0041': 'NtDeleteValueKey',
 '0x0046': 'NtEnumerateBootEntries',
 '0x0047': 'NtEnumerateKey',
 '0x0044': 'NtDuplicateObject',
 '0x0045': 'NtDuplicateToken',
 '0x00d6': 'NtSetDebugFilterState',
 '0x0048': 'NtEnumerateSystemEnvironmentValuesEx',
 '0x0049': 'NtEnumerateValueKey',
 '0x00a7': 'NtQuerySection',
 '0x00a6': 'NtQueryQuotaInformationFile',
 '0x00f8': 'NtSetVolumeInformationFile',
 '0x00d4': 'NtSetBootOptions',
 '0x00f4': 'NtSetTimer',
 '0x00a1': 'NtQueryMultipleValueKey',
 '0x00f6': 'NtSetUuidSeed',
 '0x00d5': 'NtSetContextThread',
 '0x00f0': 'NtSetSystemInformation',
 '0x00d2': 'NtSecureConnectPort',
 '0x00f2': 'NtSetSystemTime',
 '0x00a0': 'NtQueryKey',
 '0x00ea': 'NtSetLowEventPair',
 '0x00ec': 'NtSetQuotaInformationFile',
 '0x00eb': 'NtSetLowWaitHighEventPair',
 '0x00ee': 'NtSetSystemEnvironmentValue',
 '0x00ed': 'NtSetSecurityObject',
 '0x00f7': 'NtSetValueKey',
 '0x00ef': 'NtSetSystemEnvironmentValueEx',
 '0x00a2': 'NtQueryMutant',
 '0x00d8': 'NtSetDefaultLocale',
 '0x010f': 'NtWaitForSingleObject',
 '0x010e': 'NtWaitForMultipleObjects',
 '0x00d9': 'NtSetDefaultUILanguage',
 '0x010c': 'NtVdmControl',
 '0x010b': 'NtUnmapViewOfSection',
 '0x010a': 'NtUnlockVirtualMemory',
 '0x00a5': 'NtQueryPerformanceCounter',
 '0x006d': 'NtModifyBootEntry',
 '0x006e': 'NtNotifyChangeDirectoryFile',
 '0x006f': 'NtNotifyChangeKey',
 '0x00d3': 'NtSetBootEntryOrder',
 '0x006a': 'NtMapUserPhysicalPages',
 '0x006b': 'NtMapUserPhysicalPagesScatter',
 '0x006c': 'NtMapViewOfSection',
 '0x0051': 'NtFlushWriteBuffer',
 '0x0050': 'NtFlushVirtualMemory',
 '0x0053': 'NtFreeVirtualMemory',
 '0x0052': 'NtFreeUserPhysicalPages',
 '0x0055': 'NtGetContextThread',
 '0x0054': 'NtFsControlFile',
 '0x0057': 'NtGetPlugPlayEvent',
 '0x0056': 'NtGetDevicePowerState',
 '0x0059': 'NtImpersonateAnonymousToken',
 '0x0058': 'NtGetWriteWatch',
 '0x00c8': 'NtRequestWaitReplyPort',
 '0x00f5': 'NtSetTimerResolution',
 '0x0118': 'NtOpenKeyedEvent',
 '0x0119': 'NtReleaseKeyedEvent',
 '0x0110': 'NtWaitHighEventPair',
 '0x0111': 'NtWaitLowEventPair',
 '0x00f3': 'NtSetThreadExecutionState',
 '0x0113': 'NtWriteFileGather',
 '0x0114': 'NtWriteRequestData',
 '0x0115': 'NtWriteVirtualMemory',
 '0x0116': 'NtYieldExecution',
 '0x0117': 'NtCreateKeyedEvent',
 '0x00cb': 'NtResetWriteWatch',
 '0x005a': 'NtImpersonateClientOfPort',
 '0x005c': 'NtInitializeRegistry',
 '0x005b': 'NtImpersonateThread',
 '0x005e': 'NtIsProcessInJob',
 '0x005d': 'NtInitiatePowerAction',
 '0x005f': 'NtIsSystemResumeAutomatic',
 '0x011a': 'NtWaitForKeyedEvent',
 '0x0107': 'NtUnloadKey',
 '0x0106': 'NtUnloadDriver',
 '0x0105': 'NtTranslateFilePath',
 '0x0099': 'NtQueryInformationPort',
 '0x0068': 'NtMakePermanentObject',
 '0x0069': 'NtMakeTemporaryObject',
 '0x0101': 'NtTerminateProcess',
 '0x0100': 'NtTerminateJobObject',
 '0x0064': 'NtLockFile',
 '0x0065': 'NtLockProductActivationKeys',
 '0x0066': 'NtLockRegistryKey',
 '0x0067': 'NtLockVirtualMemory',
 '0x0060': 'NtListenPort',
 '0x0061': 'NtLoadDriver',
 '0x0062': 'NtLoadKey',
 '0x0063': 'NtLoadKey2',
 '0x00dc': 'NtSetEventBoostPriority',
 '0x00b7': 'NtReadFile',
 '0x0104': 'NtTraceEvent',
 '0x0098': 'NtQueryInformationJobObject',
 '0x00c6': 'NtRequestDeviceWakeup',
 '0x011b': 'NtQueryPortInformationProcess',
 '0x0112': 'NtWriteFile',
 '0x00ad': 'NtQuerySystemInformation'},
 'Vista': {'0x0172': 'NtCancelIoFileEx',
 '0x0173': 'NtCancelSynchronousIoFile',
 '0x0079': 'NtDeleteFile',
 '0x0078': 'NtDeleteDriverEntry',
 '0x0176': 'NtPullTransaction',
 '0x0177': 'NtMarshallTransaction',
 '0x0174': 'NtRemoveIoCompletionEx',
 '0x0175': 'NtRegisterProtocolAddressInformation',
 '0x0073': 'NtDebugActiveProcess',
 '0x0072': 'NtCreateWaitablePort',
 '0x0178': 'NtPropagationComplete',
 '0x0012': 'NtAllocateVirtualMemory',
 '0x0077': 'NtDeleteBootEntry',
 '0x0076': 'NtDeleteAtom',
 '0x0075': 'NtDelayExecution',
 '0x0074': 'NtDebugContinue',
 '0x00ba': 'NtOpenJobObject',
 '0x00bb': 'NtOpenKey',
 '0x00bc': 'NtOpenMutant',
 '0x00bd': 'NtOpenPrivateNamespace',
 '0x00be': 'NtOpenObjectAuditAlarm',
 '0x00bf': 'NtOpenProcess',
 '0x000f': 'NtAllocateLocallyUniqueId',
 '0x000d': 'NtAlertResumeThread',
 '0x000e': 'NtAlertThread',
 '0x000b': 'NtAdjustGroupsToken',
 '0x000c': 'NtAdjustPrivilegesToken',
 '0x000a': 'NtAddDriverEntry',
 '0x017b': 'NtReleaseWorkerFactoryWorker',
 '0x017c': 'NtWaitForWorkViaWorkerFactory',
 '0x017a': 'NtCreateWorkerFactory',
 '0x017f': 'NtWorkerFactoryWorkerReady',
 '0x017d': 'NtSetInformationWorkerFactory',
 '0x017e': 'NtQueryInformationWorkerFactory',
 '0x007c': 'NtDeleteObjectAuditAlarm',
 '0x007b': 'NtDeletePrivateNamespace',
 '0x007a': 'NtDeleteKey',
 '0x007f': 'NtDisplayString',
 '0x007e': 'NtDeviceIoControlFile',
 '0x007d': 'NtDeleteValueKey',
 '0x00f8': 'NtQueryTimerResolution',
 '0x0128': 'NtSetEaFile',
 '0x0008': 'NtAddAtom',
 '0x0009': 'NtAddBootEntry',
 '0x0006': 'NtAccessCheckByTypeResultListAndAuditAlarm',
 '0x0007': 'NtAccessCheckByTypeResultListAndAuditAlarmByHandle',
 '0x0004': 'NtAccessCheckByTypeAndAuditAlarm',
 '0x0005': 'NtAccessCheckByTypeResultList',
 '0x0002': 'NtAccessCheckAndAuditAlarm',
 '0x0003': 'NtAccessCheckByType',
 '0x0000': 'NtAcceptConnectPort',
 '0x0001': 'NtAccessCheck',
 '0x00b8': 'NtOpenFile',
 '0x00b9': 'NtOpenIoCompletion',
 '0x0171': 'NtGetNextThread',
 '0x00f5': 'NtQuerySystemInformation',
 '0x00b0': 'NtModifyBootEntry',
 '0x00b1': 'NtModifyDriverEntry',
 '0x00b2': 'NtNotifyChangeDirectoryFile',
 '0x00b3': 'NtNotifyChangeKey',
 '0x00b4': 'NtNotifyChangeMultipleKeys',
 '0x00b5': 'NtOpenDirectoryObject',
 '0x00b6': 'NtOpenEvent',
 '0x00b7': 'NtOpenEventPair',
 '0x00f7': 'NtQueryTimer',
 '0x00f0': 'NtQuerySecurityObject',
 '0x00f1': 'NtQuerySemaphore',
 '0x00f2': 'NtQuerySymbolicLinkObject',
 '0x00f3': 'NtQuerySystemEnvironmentValue',
 '0x0071': 'NtStartTm',
 '0x0179': 'NtPropagationFailed',
 '0x0095': 'NtGetContextThread',
 '0x0094': 'NtFsControlFile',
 '0x0097': 'NtGetNlsSectionPtr',
 '0x0096': 'NtGetDevicePowerState',
 '0x0091': 'NtFreeVirtualMemory',
 '0x0090': 'NtFreeUserPhysicalPages',
 '0x0093': 'NtFreezeTransactions',
 '0x0092': 'NtFreezeRegistry',
 '0x0099': 'NtGetWriteWatch',
 '0x0098': 'NtGetPlugPlayEvent',
 '0x009e': 'NtInitializeRegistry',
 '0x009d': 'NtInitializeNlsFiles',
 '0x009f': 'NtInitiatePowerAction',
 '0x009a': 'NtImpersonateAnonymousToken',
 '0x009c': 'NtImpersonateThread',
 '0x009b': 'NtImpersonateClientOfPort',
 '0x004b': 'NtCreateSymbolicLinkObject',
 '0x004c': 'NtCreateThread',
 '0x004a': 'NtCreateSemaphore',
 '0x004f': 'NtCreateTransaction',
 '0x004d': 'NtCreateTimer',
 '0x004e': 'NtCreateToken',
 '0x012e': 'NtSetInformationFile',
 '0x00fe': 'NtRaiseHardError',
 '0x00ff': 'NtReadFile',
 '0x012f': 'NtSetInformationJobObject',
 '0x012a': 'NtSetEventBoostPriority',
 '0x00fa': 'NtQueryVirtualMemory',
 '0x012c': 'NtSetHighWaitLowEventPair',
 '0x012b': 'NtSetHighEventPair',
 '0x0042': 'NtCreateNamedPipeFile',
 '0x0043': 'NtCreatePrivateNamespace',
 '0x0040': 'NtCreateMailslotFile',
 '0x0041': 'NtCreateMutant',
 '0x0046': 'NtCreateProcess',
 '0x0047': 'NtCreateProcessEx',
 '0x0044': 'NtCreatePagingFile',
 '0x0045': 'NtCreatePort',
 '0x0048': 'NtCreateProfile',
 '0x0049': 'NtCreateSection',
 '0x0170': 'NtGetNextProcess',
 '0x0129': 'NtSetEvent',
 '0x00f9': 'NtQueryValueKey',
 '0x0125': 'NtSetDefaultLocale',
 '0x0124': 'NtSetDefaultHardErrorPort',
 '0x00f6': 'NtQuerySystemTime',
 '0x0126': 'NtSetDefaultUILanguage',
 '0x0121': 'NtSetBootOptions',
 '0x0120': 'NtSetBootEntryOrder',
 '0x0123': 'NtSetDebugFilterState',
 '0x0122': 'NtSetContextThread',
 '0x0070': 'NtQueryInformationEnlistment',
 '0x016a': 'NtOpenKeyedEvent',
 '0x016c': 'NtWaitForKeyedEvent',
 '0x016b': 'NtReleaseKeyedEvent',
 '0x016e': 'NtGetCurrentProcessorNumber',
 '0x016d': 'NtQueryPortInformationProcess',
 '0x016f': 'NtWaitForMultipleObjects32',
 '0x0161': 'NtWaitForSingleObject',
 '0x0160': 'NtWaitForMultipleObjects',
 '0x0163': 'NtWaitLowEventPair',
 '0x0162': 'NtWaitHighEventPair',
 '0x0165': 'NtWriteFileGather',
 '0x0164': 'NtWriteFile',
 '0x0167': 'NtWriteVirtualMemory',
 '0x0166': 'NtWriteRequestData',
 '0x0169': 'NtCreateKeyedEvent',
 '0x0168': 'NtYieldExecution',
 '0x00c7': 'NtOpenThreadToken',
 '0x00c6': 'NtOpenThread',
 '0x00c5': 'NtOpenSymbolicLinkObject',
 '0x00c4': 'NtOpenSession',
 '0x0019': 'NtAlpcCreateSectionView',
 '0x0018': 'NtAlpcCreateResourceReserve',
 '0x00c1': 'NtOpenProcessTokenEx',
 '0x00c0': 'NtOpenProcessToken',
 '0x0015': 'NtAlpcConnectPort',
 '0x0014': 'NtAlpcCancelMessage',
 '0x0017': 'NtAlpcCreatePortSection',
 '0x0016': 'NtAlpcCreatePort',
 '0x0011': 'NtAllocateUuids',
 '0x0010': 'NtAllocateUserPhysicalPages',
 '0x0013': 'NtAlpcAcceptConnectPort',
 '0x00c8': 'NtOpenThreadTokenEx',
 '0x00e7': 'NtQueryKey',
 '0x00e6': 'NtQueryIoCompletion',
 '0x00cf': 'NtProtectVirtualMemory',
 '0x00ce': 'NtPrivilegedServiceAuditAlarm',
 '0x00cd': 'NtPrivilegeObjectAuditAlarm',
 '0x00cc': 'NtPrivilegeCheck',
 '0x00cb': 'NtPowerInformation',
 '0x00ca': 'NtPlugPlayControl',
 'NA': 'NtWriteErrorLogEntry',
 '0x001e': 'NtAlpcDeleteSecurityContext',
 '0x001d': 'NtAlpcDeleteSectionView',
 '0x001f': 'NtAlpcDisconnectPort',
 '0x001a': 'NtAlpcCreateSecurityContext',
 '0x001c': 'NtAlpcDeleteResourceReserve',
 '0x001b': 'NtAlpcDeletePortSection',
 '0x0062': 'NtCreateTransactionManager',
 '0x0063': 'NtOpenTransactionManager',
 '0x0069': 'NtCreateResourceManager',
 '0x0127': 'NtSetDriverEntryOrder',
 '0x00c9': 'NtOpenTimer',
 '0x00f4': 'NtQuerySystemEnvironmentValueEx',
 '0x0068': 'NtRecoverTransactionManager',
 '0x0051': 'NtQueryInformationTransaction',
 '0x0050': 'NtOpenTransaction',
 '0x0053': 'NtPrePrepareEnlistment',
 '0x0052': 'NtQueryInformationTransactionManager',
 '0x0055': 'NtCommitEnlistment',
 '0x0054': 'NtPrepareEnlistment',
 '0x0057': 'NtRollbackComplete',
 '0x0056': 'NtReadOnlyEnlistment',
 '0x0059': 'NtCommitTransaction',
 '0x0058': 'NtRollbackEnlistment',
 '0x0118': 'NtSaveKeyEx',
 '0x0119': 'NtSaveMergedKeys',
 '0x0110': 'NtRequestWaitReplyPort',
 '0x0111': 'NtRequestWakeupLatency',
 '0x0112': 'NtResetEvent',
 '0x0113': 'NtResetWriteWatch',
 '0x0114': 'NtRestoreKey',
 '0x0115': 'NtResumeProcess',
 '0x018a': 'NtGetMUIRegistryInfo',
 '0x0117': 'NtSaveKey',
 '0x005a': 'NtRollbackTransaction',
 '0x005c': 'NtPrepareComplete',
 '0x005b': 'NtPrePrepareComplete',
 '0x005e': 'NtSinglePhaseReject',
 '0x005d': 'NtCommitComplete',
 '0x005f': 'NtSetInformationTransaction',
 '0x0189': 'NtFlushInstallUILanguage',
 '0x0188': 'NtIsUILanguageComitted',
 '0x0187': 'NtClearMUILicenseInfo',
 '0x0186': 'NtGetMUILicenseInfo',
 '0x0185': 'NtListTransactions',
 '0x011c': 'NtRollbackSavepointTransaction',
 '0x011d': 'NtSavepointTransaction',
 '0x011e': 'NtSavepointComplete',
 '0x011f': 'NtSecureConnectPort',
 '0x0180': 'NtShutdownWorkerFactory',
 '0x0158': 'NtUnloadKey',
 '0x0159': 'NtUnloadKey2',
 '0x0154': 'NtTraceEvent',
 '0x0155': 'NtTraceControl',
 '0x0156': 'NtTranslateFilePath',
 '0x0157': 'NtUnloadDriver',
 '0x0150': 'NtTerminateThread',
 '0x0151': 'NtTestAlert',
 '0x0152': 'NtThawRegistry',
 '0x0153': 'NtThawTransactions',
 '0x00db': 'NtQueryEvent',
 '0x00dc': 'NtQueryFullAttributesFile',
 '0x00da': 'NtQueryEaFile',
 '0x00df': 'NtQueryInformationJobObject',
 '0x00dd': 'NtQueryInformationAtom',
 '0x00de': 'NtQueryInformationFile',
 '0x002a': 'NtCallbackReturn',
 '0x002b': 'NtCancelDeviceWakeupRequest',
 '0x002c': 'NtCancelIoFile',
 '0x002d': 'NtCancelTimer',
 '0x002e': 'NtClearEvent',
 '0x002f': 'NtClose',
 '0x00ed': 'NtQueryPerformanceCounter',
 '0x015d': 'NtUnmapViewOfSection',
 '0x015e': 'NtVdmControl',
 '0x015f': 'NtWaitForDebugEvent',
 '0x015a': 'NtUnloadKeyEx',
 '0x015b': 'NtUnlockFile',
 '0x015c': 'NtUnlockVirtualMemory',
 '0x0028': 'NtAreMappedFilesTheSame',
 '0x0029': 'NtAssignProcessToJobObject',
 '0x00d0': 'NtPulseEvent',
 '0x00d1': 'NtQueryAttributesFile',
 '0x00d6': 'NtQueryDefaultUILanguage',
 '0x00d7': 'NtQueryDirectoryFile',
 '0x00d4': 'NtQueryDebugFilterState',
 '0x00d5': 'NtQueryDefaultLocale',
 '0x0020': 'NtAlpcImpersonateClientOfPort',
 '0x0021': 'NtAlpcOpenSenderProcess',
 '0x0022': 'NtAlpcOpenSenderThread',
 '0x0023': 'NtAlpcQueryInformation',
 '0x0024': 'NtAlpcQueryInformationMessage',
 '0x0025': 'NtAlpcSendWaitReceivePort',
 '0x0026': 'NtAlpcSetInformation',
 '0x0027': 'NtApphelpCacheControl',
 '0x00d2': 'NtQueryBootEntryOrder',
 '0x00d3': 'NtQueryBootOptions',
 '0x00d8': 'NtQueryDirectoryObject',
 '0x010f': 'NtRequestPort',
 '0x010e': 'NtRequestDeviceWakeup',
 '0x010d': 'NtReplyWaitReplyPort',
 '0x010c': 'NtReplyWaitReceivePortEx',
 '0x010b': 'NtReplyWaitReceivePort',
 '0x010a': 'NtReplyPort',
 '0x006d': 'NtCreateEnlistment',
 '0x006e': 'NtOpenEnlistment',
 '0x006f': 'NtSetInformationEnlistment',
 '0x006a': 'NtOpenResourceManager',
 '0x006b': 'NtGetNotificationResourceManager',
 '0x006c': 'NtQueryInformationResourceManager',
 '0x0136': 'NtSetIoCompletion',
 '0x0137': 'NtSetLdtEntries',
 '0x0107': 'NtRemoveProcessDebug',
 '0x0106': 'NtRemoveIoCompletion',
 '0x0105': 'NtReleaseSemaphore',
 '0x0104': 'NtReleaseMutant',
 '0x0103': 'NtRegisterThreadTerminatePort',
 '0x0102': 'NtReadVirtualMemory',
 '0x0101': 'NtReadRequestData',
 '0x0100': 'NtReadFileScatter',
 '0x0064': 'NtRenameTransactionManager',
 '0x0065': 'NtRollforwardTransactionManager',
 '0x0066': 'NtRecoverEnlistment',
 '0x0067': 'NtRecoverResourceManager',
 '0x0060': 'NtSetInformationTransactionManager',
 '0x0061': 'NtSetInformationResourceManager',
 '0x0109': 'NtReplaceKey',
 '0x0108': 'NtRenameKey',
 '0x00d9': 'NtQueryDriverEntryOrder',
 '0x0116': 'NtResumeThread',
 '0x008f': 'NtFlushWriteBuffer',
 '0x008d': 'NtFlushProcessWriteBuffers',
 '0x008e': 'NtFlushVirtualMemory',
 '0x008b': 'NtFlushInstructionCache',
 '0x008c': 'NtFlushKey',
 '0x008a': 'NtFlushBuffersFile',
 '0x00a9': 'NtLockRegistryKey',
 '0x00a8': 'NtLockProductActivationKeys',
 '0x00a5': 'NtLoadKey2',
 '0x00a4': 'NtLoadKey',
 '0x00a7': 'NtLockFile',
 '0x00a6': 'NtLoadKeyEx',
 '0x00a1': 'NtIsSystemResumeAutomatic',
 '0x00a0': 'NtIsProcessInJob',
 '0x00a3': 'NtLoadDriver',
 '0x00a2': 'NtListenPort',
 '0x00ae': 'NtMapUserPhysicalPagesScatter',
 '0x00ad': 'NtMapUserPhysicalPages',
 '0x00af': 'NtMapViewOfSection',
 '0x00aa': 'NtLockVirtualMemory',
 '0x00ac': 'NtMakeTemporaryObject',
 '0x00ab': 'NtMakePermanentObject',
 '0x0086': 'NtEnumerateValueKey',
 '0x0087': 'NtExtendSection',
 '0x0084': 'NtEnumerateKey',
 '0x0085': 'NtEnumerateSystemEnvironmentValuesEx',
 '0x0082': 'NtEnumerateBootEntries',
 '0x0083': 'NtEnumerateDriverEntries',
 '0x0080': 'NtDuplicateObject',
 '0x0081': 'NtDuplicateToken',
 '0x0088': 'NtFilterToken',
 '0x0089': 'NtFindAtom',
 '0x014c': 'NtSuspendThread',
 '0x014b': 'NtSuspendProcess',
 '0x014a': 'NtStopProfile',
 '0x014f': 'NtTerminateProcess',
 '0x014e': 'NtTerminateJobObject',
 '0x014d': 'NtSystemDebugControl',
 '0x0149': 'NtStartProfile',
 '0x0148': 'NtSignalAndWaitForSingleObject',
 '0x0143': 'NtSetTimerResolution',
 '0x0142': 'NtSetTimer',
 '0x0141': 'NtSetThreadExecutionState',
 '0x0140': 'NtSetSystemTime',
 '0x0147': 'NtShutdownSystem',
 '0x0146': 'NtSetVolumeInformationFile',
 '0x0145': 'NtSetValueKey',
 '0x0144': 'NtSetUuidSeed',
 '0x0037': 'NtCreateDebugObject',
 '0x0036': 'NtContinue',
 '0x0035': 'NtConnectPort',
 '0x0034': 'NtCompressKey',
 '0x0033': 'NtCompleteConnectPort',
 '0x0032': 'NtCompareTokens',
 '0x0031': 'NtCompactKeys',
 '0x0030': 'NtCloseObjectAuditAlarm',
 '0x0039': 'NtCreateEvent',
 '0x0038': 'NtCreateDirectoryObject',
 '0x00e1': 'NtQueryInformationProcess',
 '0x00e0': 'NtQueryInformationPort',
 '0x00e3': 'NtQueryInformationToken',
 '0x00e2': 'NtQueryInformationThread',
 '0x00e5': 'NtQueryIntervalProfile',
 '0x00e4': 'NtQueryInstallUILanguage',
 '0x0138': 'NtSetLowEventPair',
 '0x0139': 'NtSetLowWaitHighEventPair',
 '0x00e9': 'NtQueryMutant',
 '0x00e8': 'NtQueryMultipleValueKey',
 '0x0134': 'NtSetInformationToken',
 '0x0135': 'NtSetIntervalProfile',
 '0x0132': 'NtSetInformationProcess',
 '0x0133': 'NtSetInformationThread',
 '0x0130': 'NtSetInformationKey',
 '0x0131': 'NtSetInformationObject',
 '0x003f': 'NtCreateKey',
 '0x003e': 'NtCreateJobSet',
 '0x003d': 'NtCreateJobObject',
 '0x003c': 'NtCreateIoCompletion',
 '0x003b': 'NtCreateFile',
 '0x003a': 'NtCreateEventPair',
 '0x00fd': 'NtRaiseException',
 '0x012d': 'NtSetInformationDebugObject',
 '0x013e': 'NtSetSystemInformation',
 '0x00ea': 'NtQueryObject',
 '0x00ec': 'NtQueryOpenSubKeysEx',
 '0x00eb': 'NtQueryOpenSubKeys',
 '0x00ee': 'NtQueryQuotaInformationFile',
 '0x00fb': 'NtQueryVolumeInformationFile',
 '0x00ef': 'NtQuerySection',
 '0x013f': 'NtSetSystemPowerState',
 '0x013d': 'NtSetSystemEnvironmentValueEx',
 '0x00fc': 'NtQueueApcThread',
 '0x013b': 'NtSetSecurityObject',
 '0x013c': 'NtSetSystemEnvironmentValue',
 '0x013a': 'NtSetQuotaInformationFile',
 '0x011a': 'NtClearSavepointTransaction',
 '0x00c3': 'NtOpenSemaphore',
 '0x011b': 'NtClearAllSavepointsTransaction',
 '0x00c2': 'NtOpenSection',
 '0x0184': 'NtMapCMFModule',
 '0x0183': 'NtQueryLicenseValue',
 '0x0181': 'NtCreateThreadEx'}}




def usage(imm):
    
    imm.log("!syscall PyCommand (c) Immunity Inc.")
    imm.log("Usage: !syscall -m <modulename> [-f <filename>]")
    imm.log("-m  Module to be analyzed. (Required)")
    imm.log("-f  Specify a filename to log all information to. (Optional)")

def main(args):
    
    imm = Debugger()
    
    log_file = None
    module   = ""
    error    = False
    
    try:
        opts,argo = getopt.getopt(args, "m:f")
    except:
        usage(imm)
	return "See log for usage info"
    
    for o,a in opts:
        if o == "-m":
            module = a
        if o == "-f":
            log_file = a
            
    # We key into the syscall_table using the OS 
    # getOsInformation returns ["Windows", "XP", "5.1.2600"]
    global syscall_table
    syscall_key = imm.getOsInformation()[1]
    
    # Analyse the binary, and then grab all of the 
    # functions
    executable = imm.getModule( module )

    if executable is None:        
        imm.log("[*] Error finding module, please check the filename.")
        return usage(imm)
    
    exec_base  = executable.getCodebase()
    
    if not executable.isAnalysed():
        imm.analyseCode( exec_base )
    
    # In ImmLib you can use assembly instructions and wildcard
    # search patterns the CONST below means match against any
    # constants used as as operand
    syscall_sig = "MOV EAX, CONST       \n \
                   MOV EDX, 0x7FFE0300  \n \
                   CALL [EDX]"
    
    address_list= imm.searchCommandsOnModule( exec_base, syscall_sig )
    
    syscall_count = 0
    for address in address_list:
        
        # Simply decode the function that this call
        # resides in
        address = int(address[0])                      
        resident_function = imm.decodeAddress( address )
        
        # Attempt to map the opcode from our syscall table
        #syscall_number = str(imm.disasm( function_head ).getOpData()[0])
        opcode = imm.disasm( address )
        instructions = opcode.getResult()
        
        # This is testing whether its a false-positive, just
        # means our search picked up the same binary pattern
        if "MOV EAX" not in instructions:
            imm.log("Werd")
            continue
        
        syscall_number = "0x%04x" % opcode.getOpData()[0]
        
        if syscall_table[syscall_key].has_key( syscall_number ):
            syscall_count += 1
            syscall_name = syscall_table[syscall_key][syscall_number]
            imm.setComment(address, "Syscall: %s" % syscall_name)
            
            log_message = "[*] Syscall: %s (%s) from %s" % ( syscall_name, syscall_number, resident_function )
            imm.log( "%s" % log_message, address = address)
            
            # I do this for every iteration in case there is a failure
            # we at least get the information logged as far as we could 
            if log_file is not None:
                
                try:
                    fd = open(log_file,"w")
                    fd.write( log_message )
                    fd.close()
                except IOError:
                    error = True
                    log_file
                    
    imm.log("[*] %d syscalls discovered - check log window for output." % syscall_count)
    
    if error == True:
        imm.log("[*] Unable to save to log file, please check pathname and permissions.")
    
    return "[*] %d syscalls discovered - check log window for output." % syscall_count
